/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.entity.AreaEffectCloud3DEntity;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.module.Modules;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.Reflection;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.ChargingPlayerPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.boss.dragon.phase.StrafePlayerPhase;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Attack", description="Makes the dragon hit harder in various different ways")
public class AttackFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> increasedDirectDamageConfig;
    private final ForgeConfigSpec.ConfigValue<Double> increasedAcidPoolDamageConfig;
    private final ForgeConfigSpec.ConfigValue<Double> chargePlayerMaxChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fireballMaxChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> increaseMaxRiseAndFallConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> fireballExplosionDamagesConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> fireball3DEffectCloudConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fireballVelocityMultiplierConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxBonusFireballConfig;
    public double increasedDirectDamage = 0.125;
    public double increasedAcidPoolDamage = 0.11;
    public double chargePlayerMaxChance = 0.5;
    public double fireballMaxChance = 0.4;
    public boolean increaseMaxRiseAndFall = true;
    public boolean fireballExplosionDamages = true;
    public boolean fireball3DEffectCloud = true;
    public double fireballVelocityMultiplier = 2.5;
    public double maxBonusFireball = 0.7;

    public AttackFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.increasedDirectDamageConfig = Config.builder.comment("How much more damage per difficulty (percentage) does the Ender Dragon (directly) deal per difficulty?").defineInRange("Bonus Direct Damage", this.increasedDirectDamage, 0.0, Double.MAX_VALUE);
        this.increasedAcidPoolDamageConfig = Config.builder.comment("How much more damage per difficulty (percentage) does the Ender Dragon's Acid Pool deal per difficulty?").defineInRange("Bonus Acid Pool Damage", this.increasedAcidPoolDamage, 0.0, Double.MAX_VALUE);
        this.chargePlayerMaxChanceConfig = Config.builder.comment("Normally the Ender Dragon attacks only when leaving the center platform. With this active she has a chance when she has finished charging / fireballing or before checking if she should land in the center to charge the player.\nThis is the chance to start a charge attack when the difficulty is at max (24 by default). Otherwise it scales accordingly.\nThe actual chance is: (this_value * (difficulty / max difficulty)).").defineInRange("Charge Player Max Chance", this.chargePlayerMaxChance, 0.0, Double.MAX_VALUE);
        this.fireballMaxChanceConfig = Config.builder.comment("Normally the Ender Dragon spits fireballs when a Crystal is destroyed and rarely during the fight. With this active she has a chance when she has finished charging / fireballing or before checking if she should land in the center to spit a fireball.\nThis is the chance to start a fireball attack when the difficulty is at max (24 by default). Otherwise it scales accordingly.\nThe actual chance is: (this_value * (difficulty / max difficulty)).").defineInRange("Fireball Max Chance", this.fireballMaxChance, 0.0, Double.MAX_VALUE);
        this.increaseMaxRiseAndFallConfig = Config.builder.comment("Since around 1.13/1.14 the Ender Dragon can no longer dive for more than about 3 blocks so she takes a lot to rise / fall. With this active the dragon will be able to rise and fall many more blocks, making easier to hit the player and approach the center.").define("Increase Max Rise and Fall", this.increaseMaxRiseAndFall);
        this.fireballExplosionDamagesConfig = Config.builder.comment("On impact the Acid Fireball will deal magic damage in an area.").define("Fireball Explosion Magic Damage", this.fireballExplosionDamages);
        this.fireball3DEffectCloudConfig = Config.builder.comment("On impact the Acid Fireball will generate a 3D area of effect cloud instead of a normal flat one. The 3D cloud lasts for half the time").define("Fireball 3D Area Effect Cloud", this.fireball3DEffectCloud);
        this.fireballVelocityMultiplierConfig = Config.builder.comment("Speed multiplier for the Dragon Fireball.").defineInRange("Fireball Velocity Multiplier", this.fireballVelocityMultiplier, 0.0, Double.MAX_VALUE);
        this.maxBonusFireballConfig = Config.builder.comment("The dragon will fire (up to) this more fireballs per difficulty. A decimal number dictates the chance to shot 1 more fireball, e.g. at difficulty 2 this value is 1.4, meaning that the dragon will can shot up to 2 fireballs and has 40% chance to shot up to 3. The bonus fireballs aren't directly aimed at the player but have.").defineInRange("Bonus Fireballs", this.maxBonusFireball, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.increasedDirectDamage = (Double)this.increasedDirectDamageConfig.get();
        this.increasedAcidPoolDamage = (Double)this.increasedAcidPoolDamageConfig.get();
        this.chargePlayerMaxChance = (Double)this.chargePlayerMaxChanceConfig.get();
        this.fireballMaxChance = (Double)this.fireballMaxChanceConfig.get();
        this.increaseMaxRiseAndFall = (Boolean)this.increaseMaxRiseAndFallConfig.get();
        this.fireballExplosionDamages = (Boolean)this.fireballExplosionDamagesConfig.get();
        this.fireball3DEffectCloud = (Boolean)this.fireball3DEffectCloudConfig.get();
        this.fireballVelocityMultiplier = (Double)this.fireballVelocityMultiplierConfig.get();
        this.maxBonusFireball = (Double)this.maxBonusFireballConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        this.fireballSpeed(event.getEntity());
    }

    private void fireballSpeed(Entity entity) {
        if (!(entity instanceof DragonFireballEntity)) {
            return;
        }
        if (!this.isEnabled() || this.fireballVelocityMultiplier == 0.0) {
            return;
        }
        DragonFireballEntity fireball = (DragonFireballEntity)entity;
        if (Math.abs(fireball.field_70232_b) > 10.0 || Math.abs(fireball.field_70233_c) > 10.0 || Math.abs(fireball.field_70230_d) > 10.0) {
            entity.func_174812_G();
            return;
        }
        fireball.field_70232_b *= this.fireballVelocityMultiplier;
        fireball.field_70233_c *= this.fireballVelocityMultiplier;
        fireball.field_70230_d *= this.fireballVelocityMultiplier;
    }

    @SubscribeEvent
    public void onDamageDealt(LivingHurtEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.onDirectDamage(event);
        this.onAcidDamage(event);
    }

    private void onDirectDamage(LivingHurtEvent event) {
        if (!(event.getSource().func_76364_f() instanceof EnderDragonEntity) || event.getEntityLiving() instanceof EnderDragonEntity) {
            return;
        }
        EnderDragonEntity wither = (EnderDragonEntity)event.getSource().func_76364_f();
        CompoundNBT compoundNBT = wither.getPersistentData();
        float difficulty = compoundNBT.func_74760_g("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return;
        }
        event.setAmount(event.getAmount() * (float)(1.0 + this.increasedDirectDamage * (double)difficulty));
    }

    private void onAcidDamage(LivingHurtEvent event) {
        if (!(event.getSource().func_76346_g() instanceof EnderDragonEntity) || !(event.getSource().func_76364_f() instanceof AreaEffectCloudEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getSource().func_76346_g();
        CompoundNBT compoundNBT = dragon.getPersistentData();
        float difficulty = compoundNBT.func_74760_g("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return;
        }
        event.setAmount(event.getAmount() * (float)(1.0 + this.increasedAcidPoolDamage * (double)difficulty));
    }

    public boolean onPhaseEnd(EnderDragonEntity dragon) {
        boolean chargePlayer = this.shouldChargePlayer(dragon);
        boolean fireballPlayer = this.shouldFireballPlayer(dragon);
        if (chargePlayer && fireballPlayer) {
            if (dragon.func_70681_au().nextFloat() < 0.5f) {
                this.chargePlayer(dragon);
            } else {
                this.fireballPlayer(dragon);
            }
        } else if (chargePlayer) {
            this.chargePlayer(dragon);
        } else if (fireballPlayer) {
            this.fireballPlayer(dragon);
        }
        return chargePlayer || fireballPlayer;
    }

    private boolean shouldChargePlayer(EnderDragonEntity dragon) {
        double rng;
        if (this.chargePlayerMaxChance == 0.0) {
            return false;
        }
        if (dragon.func_184664_cU() == null) {
            return false;
        }
        CompoundNBT tags = dragon.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        double chance = this.chargePlayerMaxChance * (double)(difficulty / (float)Modules.dragon.difficulty.maxDifficulty);
        BlockPos centerPodium = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
        AxisAlignedBB boundingBox = new AxisAlignedBB(centerPodium).func_186662_g(128.0);
        List players = dragon.field_70170_p.func_225317_b(PlayerEntity.class, boundingBox);
        for (PlayerEntity player : players) {
            List endCrystals = player.field_70170_p.func_225317_b(EnderCrystalEntity.class, player.func_174813_aQ().func_186662_g(10.0));
            if (endCrystals.size() <= 0) continue;
            chance *= 2.0;
            break;
        }
        return (rng = dragon.func_70681_au().nextDouble()) < chance;
    }

    private void chargePlayer(EnderDragonEntity dragon) {
        BlockPos centerPodium = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
        AxisAlignedBB bb = new AxisAlignedBB(centerPodium).func_186662_g(128.0);
        ServerPlayerEntity player = (ServerPlayerEntity)this.getRandomPlayerNearCrystal(dragon.field_70170_p, bb);
        if (player == null) {
            return;
        }
        dragon.func_184670_cT().func_188758_a(PhaseType.field_188749_i);
        Vector3d targetPos = player.func_213303_ch();
        targetPos = targetPos.field_72448_b < dragon.func_226278_cu_() ? targetPos.func_72441_c(0.0, -6.0, 0.0) : targetPos.func_72441_c(0.0, 6.0, 0.0);
        ((ChargingPlayerPhase)dragon.func_184670_cT().func_188757_b(PhaseType.field_188749_i)).func_188668_a(targetPos);
    }

    private boolean shouldFireballPlayer(EnderDragonEntity dragon) {
        if (this.fireballMaxChance == 0.0) {
            return false;
        }
        if (dragon.func_184664_cU() == null) {
            return false;
        }
        CompoundNBT tags = dragon.getPersistentData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return false;
        }
        double chance = this.fireballMaxChance * (double)(difficulty / (float)Modules.dragon.difficulty.maxDifficulty);
        double rng = dragon.func_70681_au().nextDouble();
        return rng < chance;
    }

    private void fireballPlayer(EnderDragonEntity dragon) {
        BlockPos centerPodium = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
        AxisAlignedBB bb = new AxisAlignedBB(centerPodium).func_186662_g(128.0);
        ServerPlayerEntity player = (ServerPlayerEntity)this.getRandomPlayer(dragon.field_70170_p, bb);
        if (player == null) {
            return;
        }
        dragon.func_184670_cT().func_188758_a(PhaseType.field_188742_b);
        ((StrafePlayerPhase)dragon.func_184670_cT().func_188757_b(PhaseType.field_188742_b)).func_188686_a((LivingEntity)player);
    }

    public boolean onFireballImpact(DragonFireballEntity fireball, @Nullable Entity shooter, RayTraceResult result) {
        if (!this.isEnabled()) {
            return false;
        }
        this.onImpactExplosion(fireball, shooter, result);
        return this.onImpact3DCloud(fireball, result);
    }

    private void onImpactExplosion(DragonFireballEntity fireball, @Nullable Entity shooter, RayTraceResult result) {
        if (!this.fireballExplosionDamages) {
            return;
        }
        float difficulty = 0.0f;
        if (shooter != null) {
            CompoundNBT compoundNBT = shooter.getPersistentData();
            difficulty = compoundNBT.func_74760_g("progressivebosses:difficulty");
        }
        float damage = 4.0f * (1.0f + (float)Math.pow(difficulty, 2.0) * 0.0075f);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(result.func_216347_e(), result.func_216347_e()).func_186662_g(4.0);
        List livingEntities = fireball.field_70170_p.func_225317_b(LivingEntity.class, axisAlignedBB);
        for (LivingEntity livingEntity : livingEntities) {
            if (!(livingEntity.func_195048_a(fireball.func_213303_ch()) < 20.25)) continue;
            livingEntity.func_70097_a(new IndirectEntityDamageSource("progressivebosses:dragon_fireball", (Entity)fireball, shooter).func_76348_h().func_76349_b().func_82726_p(), damage);
        }
    }

    private boolean onImpact3DCloud(DragonFireballEntity fireball, RayTraceResult result) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.fireball3DEffectCloud) {
            return false;
        }
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            Reflection.ProjectileEntity_onEntityHit((ProjectileEntity)fireball, (EntityRayTraceResult)result);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            Reflection.ProjectileEntity_onBlockHit((ProjectileEntity)fireball, (BlockRayTraceResult)result);
        }
        Entity entity = fireball.func_234616_v_();
        if (!(result.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a().func_70028_i(entity) || fireball.field_70170_p.field_72995_K)) {
            List list = fireball.field_70170_p.func_225317_b(LivingEntity.class, fireball.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0));
            AreaEffectCloud3DEntity areaeffectcloudentity = new AreaEffectCloud3DEntity(fireball.field_70170_p, fireball.func_226277_ct_(), fireball.func_226278_cu_(), fireball.func_226281_cx_());
            if (entity instanceof LivingEntity) {
                areaeffectcloudentity.func_184481_a((LivingEntity)entity);
            }
            int waitTime = 10;
            if (entity instanceof EnderDragonEntity && entity.getPersistentData().func_74764_b("progressivebosses:difficulty")) {
                waitTime = (int)Math.max(20.0f - entity.getPersistentData().func_74760_g("progressivebosses:difficulty") / 2.0f, 10.0f);
            }
            areaeffectcloudentity.func_195059_a((IParticleData)ParticleTypes.field_197616_i);
            areaeffectcloudentity.func_184483_a(3.0f);
            areaeffectcloudentity.func_184486_b(300);
            areaeffectcloudentity.func_184485_d(waitTime);
            areaeffectcloudentity.func_184487_c((7.0f - areaeffectcloudentity.func_184490_j()) / (float)areaeffectcloudentity.func_184489_o());
            areaeffectcloudentity.func_184496_a(new EffectInstance(Effects.field_76433_i, 1, 1));
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double d0 = fireball.func_70068_e((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaeffectcloudentity.func_70107_b(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
                    break;
                }
            }
            fireball.field_70170_p.func_217379_c(2006, fireball.func_233580_cy_(), fireball.func_174814_R() ? -1 : 1);
            fireball.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
            fireball.func_70106_y();
        }
        return true;
    }

    public void fireFireball(EnderDragonEntity dragon, LivingEntity attackTarget) {
        Vector3d vector3d2 = dragon.func_70676_i(1.0f);
        double d6 = dragon.field_70986_h.func_226277_ct_() - vector3d2.field_72450_a;
        double d7 = dragon.field_70986_h.func_226283_e_(0.5) + 0.5;
        double d8 = dragon.field_70986_h.func_226281_cx_() - vector3d2.field_72449_c;
        double d9 = attackTarget.func_226277_ct_() - d6;
        double d10 = attackTarget.func_226283_e_(0.5) - d7;
        double d11 = attackTarget.func_226281_cx_() - d8;
        if (!dragon.func_174814_R()) {
            dragon.field_70170_p.func_217378_a(null, 1017, dragon.func_233580_cy_(), 0);
        }
        DragonFireballEntity dragonfireballentity = new DragonFireballEntity(dragon.field_70170_p, (LivingEntity)dragon, d9, d10, d11);
        dragonfireballentity.func_70012_b(d6, d7, d8, 0.0f, 0.0f);
        dragon.field_70170_p.func_217376_c((Entity)dragonfireballentity);
        CompoundNBT compoundNBT = dragon.getPersistentData();
        float difficulty = compoundNBT.func_74760_g("progressivebosses:difficulty");
        double fireballs = RandomHelper.getDouble((Random)dragon.func_70681_au(), (double)1.0, (double)(this.maxBonusFireball * (double)difficulty));
        double mod = fireballs - (double)((int)fireballs);
        fireballs -= mod;
        if (dragon.func_70681_au().nextDouble() < mod) {
            fireballs += 1.0;
        }
        int i = 0;
        while ((double)i < fireballs) {
            d6 = dragon.field_70986_h.func_226277_ct_() - vector3d2.field_72450_a;
            d7 = dragon.field_70986_h.func_226283_e_(0.5) + 0.5;
            d8 = dragon.field_70986_h.func_226281_cx_() - vector3d2.field_72449_c;
            d9 = attackTarget.func_226277_ct_() + RandomHelper.getDouble((Random)dragon.func_70681_au(), (double)(-fireballs), (double)fireballs) - d6;
            d10 = attackTarget.func_226283_e_(0.5) + RandomHelper.getDouble((Random)dragon.func_70681_au(), (double)(-fireballs), (double)fireballs) - d7;
            d11 = attackTarget.func_226281_cx_() + RandomHelper.getDouble((Random)dragon.func_70681_au(), (double)(-fireballs), (double)fireballs) - d8;
            if (!dragon.func_174814_R()) {
                dragon.field_70170_p.func_217378_a(null, 1017, dragon.func_233580_cy_(), 0);
            }
            dragonfireballentity = new DragonFireballEntity(dragon.field_70170_p, (LivingEntity)dragon, d9, d10, d11);
            dragonfireballentity.func_70012_b(d6, d7, d8, 0.0f, 0.0f);
            dragon.field_70170_p.func_217376_c((Entity)dragonfireballentity);
            ++i;
        }
    }

    @Nullable
    public PlayerEntity getRandomPlayer(World world, AxisAlignedBB boundingBox) {
        List players = world.func_225317_b(PlayerEntity.class, boundingBox);
        if (players.isEmpty()) {
            return null;
        }
        int r = RandomHelper.getInt((Random)world.field_73012_v, (int)0, (int)players.size());
        return (PlayerEntity)players.get(r);
    }

    @Nullable
    public PlayerEntity getRandomPlayerNearCrystal(World world, AxisAlignedBB boundingBox) {
        List players = world.func_225317_b(PlayerEntity.class, boundingBox);
        if (players.isEmpty()) {
            return null;
        }
        ArrayList<PlayerEntity> playersNearCrystals = new ArrayList<PlayerEntity>();
        for (PlayerEntity player : players) {
            List endCrystals = player.field_70170_p.func_225317_b(EnderCrystalEntity.class, player.func_174813_aQ().func_186662_g(10.0));
            if (endCrystals.size() <= 0) continue;
            playersNearCrystals.add(player);
        }
        if (playersNearCrystals.isEmpty()) {
            int r = RandomHelper.getInt((Random)world.field_73012_v, (int)0, (int)players.size());
            return (PlayerEntity)players.get(r);
        }
        int r = RandomHelper.getInt((Random)world.field_73012_v, (int)0, (int)playersNearCrystals.size());
        return (PlayerEntity)playersNearCrystals.get(r);
    }
}

